import {ReactNode} from 'react';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'types/withClassName';
import {EFooterProject} from 'components/Footer/types';
import EHeaderBorderBottomType from 'components/Header/types/EHeaderBorderBottomType';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';

import cx from './HotelPageLayout.scss';

interface IHotelPageLayoutProps extends IWithClassName {
    isHeaderShown?: boolean;
    isFooterShown?: boolean;
    children: ReactNode;
    searchFormCollapsedClassName?: string;
}

const HotelPageLayout: React.FC<IHotelPageLayoutProps> = props => {
    const {
        className,
        searchFormCollapsedClassName,
        isHeaderShown,
        isFooterShown,
        children,
    } = props;
    const deviceType = useDeviceType();

    return (
        <LayoutDefault
            className={className}
            contentClassName={cx('content')}
            footerClassName={cx('footer')}
            footerWrapperClassName={cx(
                deviceType.isDesktop && 'footer_wrapper',
            )}
            searchFormCollapsedClassName={searchFormCollapsedClassName}
            isFixedNavigation
            showNavigation
            showSearchForm
            hasSideSheetNavigation
            searchFormInitialIsExpanded={false}
            project={EProjectName.HOTELS}
            footerType={EFooterProject.HOTELS}
            showHeader={isHeaderShown}
            showFooter={isFooterShown}
            headerBorderBottomType={
                deviceType.isMobile
                    ? EHeaderBorderBottomType.NONE
                    : EHeaderBorderBottomType.FULL
            }
        >
            {children}
        </LayoutDefault>
    );
};

export default HotelPageLayout;
