import {IWithClassName} from 'types/withClassName';
import {IHotel} from 'types/hotels/hotel/IHotel';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Card from 'components/Card/Card';
import HotelShortView from 'projects/depreacted/hotels/components/HotelShortView/HotelShortView';

import cx from './HotelPageMapMarkerContent.scss';

export interface IHotelPageMapMarkerProps
    extends IWithClassName,
        IWithQaAttributes {
    hotel: IHotel;
    canRenderAddress: boolean;
    hotelsPercentDiscount?: boolean;
}

/* Constants */
const MAP_MARKER_QA = 'mapMarker';

const HotelPageMapMarkerContent: React.FC<IHotelPageMapMarkerProps> = ({
    hotel,
    canRenderAddress,
    hotelsPercentDiscount,
    className,
    ...restProps
}) => {
    const mapMarkerQaAttributes = prepareQaAttributes({
        parent: restProps,
        current: MAP_MARKER_QA,
    });

    return (
        <div className={cx('root', className)}>
            <div className={cx('hotel')}>
                <Card shadow="popup" radius="s" className={cx('hotel__card')}>
                    <HotelShortView
                        hotel={hotel}
                        hotelsPercentDiscount={hotelsPercentDiscount}
                        canRenderAddress={canRenderAddress}
                        hideImage
                        {...mapMarkerQaAttributes}
                    />
                </Card>
            </div>
            <div className={cx('marker')} />
        </div>
    );
};

export default HotelPageMapMarkerContent;
