import {IWithClassName} from 'types/withClassName';
import {IHotelOffer} from 'types/hotels/offer/IHotelOffer';
import {OperatorByIdType} from 'types/hotels/offer/IHotelsOperator';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import {EFormatLabel} from 'projects/depreacted/hotels/components/HotelsCancellationInfo/HotelsCancellationInfo';

import HotelPageOfferDesktop from './blocks/HotelPageOfferDesktop/HotelPageOfferDesktop';
import HotelPageOfferMobile from './blocks/HotelPageOfferMobile/HotelPageOfferMobile';

/* Component Types */
export interface IBaseHotelPageOfferProps
    extends IWithClassName,
        IWithQaAttributes {
    offer: IHotelOffer;
    operatorById: OperatorByIdType;
    isIe: boolean;
    isColumnLabels?: boolean;
    isShortOperator?: boolean;
    isBookOnYandex: boolean;
    onOfferSelect: () => void;
    isHeadless?: boolean;
    formatCancellationInfoLabel?: EFormatLabel;
}

export interface IHotelPageOfferProps extends IBaseHotelPageOfferProps {
    isMobile: boolean;
}

/** TODO: 💀 DeadCode - https://st.yandex-team.ru/TRAVELFRONT-6523 */
const HotelPageOffer = ({isMobile, ...props}: IHotelPageOfferProps) => {
    return isMobile ? (
        <HotelPageOfferMobile {...props} />
    ) : (
        <HotelPageOfferDesktop {...props} />
    );
};

export default HotelPageOffer;
