import {FunctionComponent} from 'react';

import {EHotelBadgeType} from 'types/hotels/offer/IHotelOffer';

import {getOperatorLinkPropsByParams} from 'projects/depreacted/hotels/utilities/getOperatorLinkPropsByParams/getOperatorLinkPropsByParams';

import * as i18nBlock from 'i18n/hotels-HotelPageOffer';

/* Components */
import HotelOfferLabels from 'projects/depreacted/hotels/components/HotelOfferLabels/HotelOfferLabels';
import Price from 'components/Price/Price';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import HotelOperator from 'projects/depreacted/hotels/components/HotelOperator/HotelOperator';
import HotelOfferBadges from 'projects/depreacted/hotels/components/HotelOfferBadges/HotelOfferBadges';
import {EFormatLabel} from 'projects/depreacted/hotels/components/HotelsCancellationInfo/HotelsCancellationInfo';

import {IBaseHotelPageOfferProps} from '../../HotelPageOffer';

/* Styles */
import cx from './HotelPageOfferMobile.scss';

export interface IHotelPageOfferMobileProps extends IBaseHotelPageOfferProps {}

/** TODO: 💀 DeadCode - https://st.yandex-team.ru/TRAVELFRONT-6523 */
const HotelPageOfferMobile: FunctionComponent<IHotelPageOfferMobileProps> = ({
    className,
    offer,
    operatorById,
    isBookOnYandex,
    isHeadless,
    onOfferSelect,
}) => {
    const {operatorId, price, name, landingUrl} = offer;
    const suitableBadges = isBookOnYandex
        ? offer.badges?.filter(({id}) => id !== EHotelBadgeType.HOTEL_DIRECT)
        : offer.badges;

    return (
        <section className={className}>
            <div className={cx('offerName')}>{name}</div>
            <HotelOfferLabels
                cancellationLabelClassName={cx('label')}
                mealLabelClassName={cx('label')}
                formatCancellationInfoLabel={EFormatLabel.ONLY_REFUND_TEXT}
                offer={offer}
            />
            <div className={cx('price')}>
                <div>
                    <HotelOfferBadges
                        badges={suitableBadges}
                        above={2}
                        below={2}
                    />
                    <Price className={cx('price__value')} {...price} />
                    <HotelOperator
                        operator={operatorById[operatorId]}
                        partnerUrl={landingUrl}
                        theme="black"
                        size="s"
                        onClick={onOfferSelect}
                        isHeadless={isHeadless}
                    />
                </div>
                <ButtonLink
                    theme="primary"
                    size="m-inset"
                    url={landingUrl}
                    onClick={onOfferSelect}
                    {...getOperatorLinkPropsByParams({isHeadless})}
                >
                    {i18nBlock.select()}
                </ButtonLink>
            </div>
        </section>
    );
};

export default HotelPageOfferMobile;
