import React, {Component, ReactNode} from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {
    ESearchFormSize,
    ESearchFormTriggerViewType,
} from 'components/SearchForm/types';

import {deviceModMobile} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-HotelPageSearchForm';

import SearchForm from 'projects/depreacted/hotels/components/SearchForm/SearchForm';
import {TButtonTheme} from 'components/Button/Button';
import {IFormFieldsRef} from 'components/SearchForm/SearchForm';

import cx from './HotelPageSearchForm.scss';

/* Component Types */

export interface IHotelPageSearchFormProps
    extends IWithDeviceType,
        IWithQaAttributes {
    size?: ESearchFormSize;
    submitButtonTheme?: TButtonTheme;
    submitButtonText?: string;
    formRef?: React.RefObject<HTMLFormElement>;
    fieldsRef?: React.MutableRefObject<IFormFieldsRef | undefined>;
}

class HotelPageSearchForm extends Component<IHotelPageSearchFormProps> {
    /* Render */

    private renderSearchForm = (): ReactNode => {
        const {
            deviceType,
            size,
            submitButtonTheme,
            submitButtonText,
            formRef,
            fieldsRef,
        } = this.props;
        const {isDesktop} = deviceType;

        return (
            <SearchForm
                searchFormClassName={cx(
                    deviceModMobile('searchForm', deviceType),
                )}
                travellersClassName={cx(
                    deviceModMobile('travellers', deviceType),
                )}
                travellersTriggerClassName={cx(
                    deviceModMobile('travellersTrigger', deviceType),
                )}
                datePickerTriggerClassName={cx(
                    deviceModMobile('datePickerTrigger', deviceType),
                )}
                submitButtonClassName={cx(
                    'submitButton',
                    deviceModMobile('submitButton', deviceType),
                )}
                size={size}
                triggerViewType={ESearchFormTriggerViewType.TILE}
                submitButtonTheme={submitButtonTheme || 'secondary'}
                hasDelayBeforeUpdateLocation
                hasDirectionSuggest={false}
                hideDateClearButton
                submitButtonText={submitButtonText || i18nBlock.submitButton()}
                canSubmitOnChange={isDesktop}
                canToggleDropdowns={isDesktop}
                isFullDateFormat={isDesktop}
                formRef={formRef}
                fieldsRef={fieldsRef}
                {...prepareQaAttributes(this.props)}
            />
        );
    };

    render(): ReactNode {
        const {
            deviceType: {isIe},
        } = this.props;

        /* Revert after fix Dropdown position */
        if (isIe) {
            return null;
        }

        return this.renderSearchForm();
    }
}

export default HotelPageSearchForm;
