import React, {FunctionComponent} from 'react';

import {IBreadcrumbs} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/types';
import {IWithClassName} from 'types/withClassName';

import {hotelsURLs} from 'projects/depreacted/hotels/utilities/urls';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceModMobile} from 'utilities/stylesUtils';
import {getBreadcrumbInfo} from 'projects/depreacted/hotels/pages/GeoRegionPage/utilities/getBreadcrumbInfo';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-GeoRegionPage';

import {LinkBreadcrumbs} from 'components/LinkBreadcrumbs/LinkBreadcrumbs';

import cx from './HotelPageSeoBreadCrumbs.scss';

export interface IBreadCrumbsProps extends IWithClassName {
    breadcrumbs: IBreadcrumbs;
    nonce: string;
}

const HotelPageSeoBreadCrumbs: FunctionComponent<IBreadCrumbsProps> = ({
    breadcrumbs: {items},
    breadcrumbs,
    className,
    nonce,
}) => {
    const deviceType = useDeviceType();

    return (
        <LinkBreadcrumbs
            className={cx(
                'root',
                deviceModMobile('root', deviceType),
                className,
            )}
            scrollableClassName={cx('scrollable')}
            nonce={nonce}
        >
            <LinkBreadcrumbs.Item
                url={hotelsURLs.getHotelsRootUrl()}
                metaUrl={hotelsURLs.getAbsoluteHotelUrl({slug: ''})}
            >
                {i18nBlock.breadCrumbHotel()}
            </LinkBreadcrumbs.Item>

            {items.map((breadcrumb, index) => {
                const {text, link} = getBreadcrumbInfo(breadcrumb, breadcrumbs);

                return (
                    <LinkBreadcrumbs.Item
                        key={breadcrumb.slug}
                        url={index === items.length - 1 ? undefined : link}
                        metaUrl={hotelsURLs.getAbsoluteHotelUrl({
                            slug: breadcrumb.slug,
                        })}
                        {...prepareQaAttributes({
                            current: 'hotelPageBreadcrumb',
                            key: index,
                        })}
                    >
                        {text}
                    </LinkBreadcrumbs.Item>
                );
            })}
        </LinkBreadcrumbs>
    );
};

export default React.memo(HotelPageSeoBreadCrumbs);
