import {useCallback} from 'react';

import {IHotelOffer} from 'types/hotels/offer/IHotelOffer';
import {IWithClassName} from 'types/withClassName';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-HotelPageFirstOffer';

import OfferMealInfo from 'projects/depreacted/hotels/components/OfferMealInfo/OfferMealInfo';
import OfferRefundableLabel from 'projects/depreacted/hotels/components/OfferRefundableRules/OfferRefundableLabel';
import Price from 'components/Price/Price';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import Separator from 'components/Separator/Separator';
import LinkButton from 'components/LinkButton/LinkButton';
/* Init styles */

import cx from './HotelPageYandexFirstOffer.scss';

/* Component Types */
interface IHotelPageYandexFirstOffer extends IWithClassName {
    offer: IHotelOffer;
    offerCount: number;
    operatorCount: number;
    onClickAllOffersLink?: () => void;
}

const HotelPageYandexFirstOffer = (props: IHotelPageYandexFirstOffer) => {
    const {
        className,
        offerCount,
        operatorCount,
        onClickAllOffersLink,
        offer: {name, price, mealType, cancellationInfo, landingUrl},
    } = props;

    const handleAllOffersClick = useCallback(() => {
        if (onClickAllOffersLink) {
            onClickAllOffersLink();
        }
    }, [onClickAllOffersLink]);

    return (
        <section
            className={cx(className)}
            {...prepareQaAttributes('hotelFirstOffer')}
        >
            <div className={cx('offerName')}>{name}</div>
            <Price className={cx('price')} {...price} />
            {mealType && (
                <OfferMealInfo
                    className={cx('mealInfo')}
                    size="s"
                    mealInfo={mealType}
                />
            )}
            {cancellationInfo && (
                <OfferRefundableLabel
                    className={cx('refundableLabel')}
                    size="s"
                    cancellationInfo={cancellationInfo}
                />
            )}
            <ButtonLink
                className={cx('offerBookLink')}
                url={landingUrl}
                target="_blank"
                size="l"
                theme="primary"
                rel="noopener noreferrer"
            >
                {i18nBlock.offerBookLink()}
            </ButtonLink>
            <Separator />
            <LinkButton
                className={cx('allOffersLink')}
                onClick={handleAllOffersClick}
                {...prepareQaAttributes('moreOffersLink')}
            >
                {i18nBlock.moreOffersLink({offerCount, operatorCount})}
            </LinkButton>
        </section>
    );
};

export default HotelPageYandexFirstOffer;
