import {FunctionComponent} from 'react';

import {MIN_PERCENT_TO_SHOW} from 'projects/depreacted/hotels/constants/discount';

import {IHotelOffer} from 'types/hotels/offer/IHotelOffer';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/components-PlusInfoPopup';

import Flex from 'components/Flex/Flex';
import Price from 'components/Price/Price';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import ArrowRightIcon from 'icons/16/ArrowRight';
import YandexTravelLogo from 'components/YandexTravelLogo/YandexTravelLogo';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';
import HotelOfferBadges from 'projects/depreacted/hotels/components/HotelOfferBadges/HotelOfferBadges';
import DiscountInfo from 'projects/depreacted/hotels/components/HotelCard/components/DiscountInfo/DiscountInfo';

import cx from './YandexOffer.scss';

interface IYandexOfferProps extends IWithClassName {
    offer: IHotelOffer;
    withHighlight: boolean;
    hotelsPercentDiscount?: boolean;
}

const YandexOffer: FunctionComponent<IYandexOfferProps> = ({
    className,
    offer,
    withHighlight,
    hotelsPercentDiscount,
}) => {
    const deviceType = useDeviceType();
    const {isMobile} = deviceType;
    const showDiscountPercent =
        hotelsPercentDiscount &&
        offer.discountInfo?.percent &&
        offer.discountInfo.percent >= MIN_PERCENT_TO_SHOW;

    return (
        <Flex
            className={cx(
                'root',
                deviceMods('root', deviceType),
                {
                    root_highlight: withHighlight,
                    root_hasBadges: Number(offer.badges?.length) > 0,
                },
                className,
            )}
            alignItems={isMobile ? 'flex-start' : 'center'}
            flexDirection={isMobile ? 'column' : 'row'}
        >
            <YandexTravelLogo
                isSmall
                className={cx('travelLogo')}
                travelLogoLabelClassName={cx('travelLogoLabel')}
                url={offer.landingUrl}
            />
            <Flex
                className={cx('priceAndButton')}
                flexDirection="row"
                alignItems={isMobile ? 'flex-end' : 'center'}
                justifyContent="space-between"
            >
                <Flex className={cx('priceWrap')} flexDirection="column">
                    <Flex alignItems="center">
                        <Price
                            className={cx('price')}
                            color={
                                offer.discountInfo?.strikethroughPrice &&
                                !showDiscountPercent
                                    ? 'alert'
                                    : undefined
                            }
                            {...offer.price}
                        />
                        {offer.discountInfo && (
                            <DiscountInfo
                                striketroughTextClassName={cx(
                                    'striketroughPriceWrap',
                                )}
                                priceClassName={cx('striketroughPrice')}
                                discountInfo={offer.discountInfo}
                                hotelsPercentDiscount={hotelsPercentDiscount}
                                percentSize={deviceType.isDesktop ? 's' : 'm'}
                            />
                        )}
                    </Flex>
                    {offer.offerYandexPlusInfo && (
                        <TextWithIcon
                            size="s"
                            iconLeft={YandexPlusSignColorGradientS}
                            iconLeftClassName={cx('plusIcon')}
                            text={`${i18nBlock.plusPoints({
                                plusPoints: offer.offerYandexPlusInfo.points,
                            })}${isMobile ? ` ${i18nBlock.toPlus()}` : ''}`}
                        />
                    )}
                </Flex>
                <ButtonLink
                    className={cx('button')}
                    theme={withHighlight ? 'primary' : 'secondary'}
                    url={offer.landingUrl}
                >
                    <ArrowRightIcon />
                </ButtonLink>
            </Flex>
            <HotelOfferBadges className={cx('badges')} badges={offer.badges} />
        </Flex>
    );
};

export default YandexOffer;
