import React from 'react';

import {IHotelPartnerOffer} from 'types/hotels/offer/IHotelOffer';
import {IWithClassName} from 'types/withClassName';
import {OperatorByIdType} from 'types/hotels/offer/IHotelsOperator';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-HotelPagePartnerOffersInfo';

import HotelOperator from 'projects/depreacted/hotels/components/HotelOperator/HotelOperator';
import Offer from 'projects/depreacted/hotels/pages/HotelPage/components/OffersInfo/components/Offer/Offer';
import OfferMealInfo from 'projects/depreacted/hotels/components/OfferMealInfo/OfferMealInfo';
import HotelsCancellationInfo from 'projects/depreacted/hotels/components/HotelsCancellationInfo/HotelsCancellationInfo';

import cx from './PartnerOffer.scss';

export interface IHotelPageOfferMobileProps
    extends IWithClassName,
        IWithQaAttributes {
    hasMainOffers: boolean;
    nightsCount?: number;
    offer: IHotelPartnerOffer;
    operatorById: OperatorByIdType;
    onOfferSelect: () => void;
    isHeadless?: boolean;
}

const PartnerOffer: React.FC<IHotelPageOfferMobileProps> = ({
    className,
    offer,
    operatorById,
    isHeadless,
    onOfferSelect,
    hasMainOffers,
    nightsCount,
    ...rest
}) => {
    const {
        operatorId,
        defaultOffer,
        defaultOfferCancellationInfo,
        defaultOfferPansion,
    } = offer;

    return (
        <Offer
            className={cx(className, 'offer')}
            isHeadless={isHeadless}
            title={
                <HotelOperator
                    iconClassName={cx('icon')}
                    operator={operatorById[operatorId]}
                    partnerUrl={defaultOffer.landingUrl}
                    theme="black"
                    size="l"
                    onClick={onOfferSelect}
                    isHeadless={isHeadless}
                    {...prepareQaAttributes({
                        parent: rest,
                        current: 'hotelOperator',
                    })}
                />
            }
            labels={
                <>
                    {defaultOfferPansion && (
                        <OfferMealInfo
                            size="m"
                            isIconHidden
                            mealInfo={defaultOfferPansion}
                        />
                    )}
                    {defaultOfferCancellationInfo && (
                        <HotelsCancellationInfo
                            cancellationInfo={defaultOfferCancellationInfo}
                        />
                    )}
                </>
            }
            nightsCount={nightsCount}
            onOfferSelect={onOfferSelect}
            price={defaultOffer.price}
            discountInfo={defaultOffer.discountInfo}
            plusInfo={defaultOffer?.offerYandexPlusInfo}
            buttonTheme={hasMainOffers ? 'secondary' : 'primary'}
            buttonText={i18nBlock.selectAction()}
            buttonUrl={defaultOffer.landingUrl}
            type="horizontal"
            isPartner
            showNightsCount={Boolean(nightsCount)}
            linkTarget="_blank"
            {...prepareQaAttributes(rest)}
        />
    );
};

export default PartnerOffer;
