import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {deviceModDesktop, deviceModMobile} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import {CardWithDeviceLayout} from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Separator from 'components/Separator/Separator';

import cx from './PartnerOffersSkeleton.scss';

export interface IPartnerOffersInfoSkeleton extends IWithClassName {}

const PartnerOfferSkeleton: React.FC = () => {
    const {isDesktop} = useDeviceType();

    return (
        <div className={cx('offer')}>
            <div className={cx('head')}>
                <div className={cx('image')} />
                <div className={cx('title')} />
            </div>
            <div className={cx('text')}>
                <div className={cx('text__row')} />
                {isDesktop && <div className={cx('text__row')} />}
            </div>
        </div>
    );
};

const PartnerOffersSkeleton: React.FC<IPartnerOffersInfoSkeleton> = ({
    className,
}) => {
    const deviceType = useDeviceType();

    if (deviceType.isMobile) {
        return (
            <div
                className={cx(
                    className,
                    'root',
                    deviceModMobile('root', deviceType),
                )}
            >
                <CardWithDeviceLayout>
                    <PartnerOfferSkeleton />
                    <Separator />
                    <PartnerOfferSkeleton />
                    <Separator />
                    <PartnerOfferSkeleton />
                </CardWithDeviceLayout>
            </div>
        );
    }

    return (
        <div
            className={cx(
                className,
                'root',
                deviceModDesktop('root', deviceType),
            )}
        >
            <PartnerOfferSkeleton />
            <Separator />
            <PartnerOfferSkeleton />
            <Separator />
            <PartnerOfferSkeleton />
        </div>
    );
};

export default PartnerOffersSkeleton;
