import {FunctionComponent} from 'react';

import {IRoomAmenity} from 'types/hotels/offer/IHotelRoom';
import {IWithClassName} from 'types/withClassName';

import getRoomAmenityComponentIconById from './utilities/getRoomAmenityComponentIconById';

/* Components */
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

/* Styles */
import cx from './Amenity.scss';

/* Types */
export interface IHotelPageRoomAmenityProps extends IWithClassName {
    amenity: IRoomAmenity;
    amenityTextSize: 's' | 'm';
    amenityFontWeight: 'normal' | 'medium' | 'bold';
}

const Amenity: FunctionComponent<IHotelPageRoomAmenityProps> = ({
    className,
    amenity,
    amenityTextSize,
    amenityFontWeight,
}) => {
    const {icon, name} = amenity;

    return (
        <TextWithIcon
            size={amenityTextSize}
            text={name}
            className={cx('amenity', className, {
                [`amenity_fontWeight_${amenityFontWeight}`]:
                    Boolean(amenityFontWeight),
            })}
            iconLeftClassName={cx('amenityIcon')}
            iconLeft={getRoomAmenityComponentIconById(icon)}
        />
    );
};

export default Amenity;
