import {FunctionComponent} from 'react';

import {IRoomAmenityGroup} from 'types/hotels/offer/IHotelRoom';
import {IWithClassName} from 'types/withClassName';

import getRoomAmenityGroupComponentIconById from './utilities/getRoomAmenityGroupComponentIconById';

/* Components */
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import Text from 'components/Text/Text';

/* Styles */
import cx from './AmenityGroups.scss';

/* Types */
export interface IAmenityGroupsProps extends IWithClassName {
    amenityGroups?: IRoomAmenityGroup[];
    canRenderIcons?: boolean;
    amenityTextSize: 's' | 'm';
    amenityGroupNameFontWeight: 'medium' | 'bold';
    viewType: 'column' | 'table';
}

const AmenityGroups: FunctionComponent<IAmenityGroupsProps> = ({
    className,
    amenityGroups,
    canRenderIcons = true,
    amenityTextSize,
    amenityGroupNameFontWeight,
    viewType,
}) => {
    if (!amenityGroups?.length) {
        return null;
    }

    return (
        <section
            className={cx(
                'root',
                {[`root_viewType_${viewType}`]: Boolean(viewType)},
                className,
            )}
        >
            {amenityGroups.map(amenityGroup => (
                <div key={amenityGroup.id} className={cx('amenityGroup')}>
                    <TextWithIcon
                        text={amenityGroup.name}
                        size={amenityTextSize}
                        className={cx('amenityGroupName', {
                            [`amenityGroupName_fontWeight_${amenityGroupNameFontWeight}`]:
                                Boolean(amenityGroupNameFontWeight),
                        })}
                        iconLeftClassName={cx('amenityGroupIcon')}
                        iconLeft={
                            canRenderIcons
                                ? getRoomAmenityGroupComponentIconById(
                                      amenityGroup.icon,
                                  )
                                : undefined
                        }
                    />
                    <div className={cx('amenities')}>
                        {amenityGroup.amenities.map(amenity => (
                            <Text
                                key={amenity.id}
                                className={cx('amenity')}
                                size={amenityTextSize}
                                color="primary"
                                tag="div"
                            >
                                {amenity.name}
                            </Text>
                        ))}
                    </div>
                </div>
            ))}
        </section>
    );
};

export default AmenityGroups;
