import {ComponentType} from 'react';

import {IIconProps} from 'icons/types/icon';
import {ERoomAmenityGroupIcon} from 'types/hotels/offer/IHotelRoom';

import IncludeIcon from 'icons/16/Include';
import Kitchen from 'icons/16/Kitchen';
import Bathroom from 'icons/16/Bathroom';
import FoodAndBeverage from 'icons/16/FoodAndBeverage';
import Furniture from 'icons/16/Furniture';
import Disabled from 'icons/16/Disabled';
import DryCleaning from 'icons/16/DryCleaning';
import Socket from 'icons/16/Socket';
import Sleeping from 'icons/16/Sleeping';
import Entertainment from 'icons/16/Entertainment';
import InternetAndTelephony from 'icons/16/InternetAndTelephony';
import ExternalArea from 'icons/16/ExternalArea';

const getRoomAmenityGroupComponentIconById = (
    icon: ERoomAmenityGroupIcon,
): ComponentType<IIconProps> => {
    switch (icon) {
        case ERoomAmenityGroupIcon.KITCHEN: {
            return Kitchen;
        }

        case ERoomAmenityGroupIcon.BATHROOM: {
            return Bathroom;
        }

        case ERoomAmenityGroupIcon.FOOD: {
            return FoodAndBeverage;
        }

        case ERoomAmenityGroupIcon.FURNITURE: {
            return Furniture;
        }

        case ERoomAmenityGroupIcon.ACCESSIBILITY: {
            return Disabled;
        }

        case ERoomAmenityGroupIcon.CLOTHES: {
            return DryCleaning;
        }

        case ERoomAmenityGroupIcon.ELECTRONICS: {
            return Socket;
        }

        case ERoomAmenityGroupIcon.SLEEP: {
            return Sleeping;
        }

        case ERoomAmenityGroupIcon.ENTERTAINMENT: {
            return Entertainment;
        }

        case ERoomAmenityGroupIcon.INTERNET_TELEPHONY: {
            return InternetAndTelephony;
        }

        case ERoomAmenityGroupIcon.OUTSIDE_AREA_AND_VIEW: {
            return ExternalArea;
        }

        default: {
            return IncludeIcon;
        }
    }
};

export default getRoomAmenityGroupComponentIconById;
