import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IRoomBedGroup} from 'types/hotels/offer/IHotelRoom';

import * as i18nBlock from 'i18n/hotels-HotelPageRooms';

import Intersperse from 'components/Intersperse/Intersperse';

import BedGroup from '../BedGroup/BedGroup';

/* Init styles */
import cx from './BedGroups.scss';

/* Types */
export interface IBedGroupsProps extends IWithClassName {
    bedGroups: IRoomBedGroup[];
    bedClassName?: string;
    bedGroupClassName?: string;
    canViewBedName?: boolean;
    canViewImage?: boolean;
    isSeparatorBlock?: boolean;
}

const BedGroups: FunctionComponent<IBedGroupsProps> = ({
    className,
    bedClassName,
    bedGroupClassName,
    bedGroups,
    canViewBedName,
    canViewImage,
    isSeparatorBlock,
    children,
}) => {
    return (
        <div className={cx('root', className)}>
            <Intersperse
                separator={
                    isSeparatorBlock ? (
                        <div className={cx('separator')}>
                            {i18nBlock.bedGroupsSeparator()}
                        </div>
                    ) : (
                        <>&nbsp;{i18nBlock.bedGroupsSeparator()} </>
                    )
                }
            >
                {bedGroups.map(bedGroup => {
                    return (
                        <BedGroup
                            key={bedGroup.id}
                            className={bedGroupClassName}
                            bedClassName={bedClassName}
                            bedGroup={bedGroup}
                            canViewBedName={canViewBedName}
                            canViewImage={canViewImage}
                        />
                    );
                })}
            </Intersperse>
            {children}
        </div>
    );
};

export default BedGroups;
