import React, {ReactNode} from 'react';

import {IHotelBoyMetaRoomWithOffers} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/types';
import {IWithClassName} from 'types/withClassName';

import {useBoolean} from 'utilities/hooks/useBoolean';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import humanizePeriod from 'utilities/dateUtils/humanizePeriod';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nNew from 'i18n/hotels-HotelPageRooms';

import NoHotelPhotoM from 'icons/illustrations/NoHotelPhoto/NoHotelPhotoM';
import Heading from 'components/Heading/Heading';
import RotatingArrowIcon from 'components/RotatingArrowIcon/RotatingArrowIcon';
import AutoHeightAnimateControl from 'components/AutoHeightAnimateControl/AutoHeightAnimateControl';

import cx from './RoomsWithoutOffers.scss';

interface IHotemPageRoomsWithoutOffersProps
    extends IWithClassName,
        IWithQaAttributes {
    rooms: IHotelBoyMetaRoomWithOffers[];
    checkinDate: string;
    checkoutDate: string;
    renderRoom: (room: IHotelBoyMetaRoomWithOffers) => ReactNode;
}

const RoomsWithoutOffers: React.FC<IHotemPageRoomsWithoutOffersProps> =
    props => {
        const {className, rooms, checkinDate, checkoutDate, renderRoom} = props;
        const deviceType = useDeviceType();

        const {
            value: isRoomsWithoutOffersExpanded,
            toggle: roomsWithoutOffersToggle,
        } = useBoolean(false);

        return (
            <div
                className={cx('roomsWithoutOffers')}
                {...prepareQaAttributes(props)}
            >
                <div className={cx('header')}>
                    {deviceType.isDesktop && (
                        <div className={cx('icon')}>
                            <NoHotelPhotoM width="51" height="56" />
                        </div>
                    )}

                    <Heading
                        level={3}
                        className={cx('label')}
                        onClick={roomsWithoutOffersToggle}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'trigger',
                        })}
                    >
                        {i18nNew.roomsWithoutOfferTitle({
                            dates: humanizePeriod(checkinDate, checkoutDate),
                        })}
                    </Heading>

                    <RotatingArrowIcon
                        rotated={isRoomsWithoutOffersExpanded}
                        onClick={roomsWithoutOffersToggle}
                        className={cx('toggle')}
                    />
                </div>

                <AutoHeightAnimateControl
                    canShowComponent={isRoomsWithoutOffersExpanded}
                >
                    <div
                        className={className}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'content',
                        })}
                    >
                        {rooms.map(renderRoom)}
                    </div>
                </AutoHeightAnimateControl>
            </div>
        );
    };

export default RoomsWithoutOffers;
