import _isEqual from 'lodash/isEqual';

import {IHotelOffer} from 'types/hotels/offer/IHotelOffer';

export default function getOffersCollapsedInfo(
    offers: IHotelOffer[],
    defaultOffer?: IHotelOffer,
) {
    const firstOffer = defaultOffer || offers[0];

    let price = firstOffer.price;
    let badges = firstOffer.badges || [];

    if (offers?.length && offers.length > 1) {
        offers.forEach(offer => {
            if (
                offer.price.value < price.value &&
                offer.price.currency === price.currency
            ) {
                price = offer.price;
            }

            badges = badges.filter(badge =>
                offer.badges?.find(item => _isEqual(item, badge)),
            );
        });
    }

    return {
        price,
        badges,
    };
}
