import _flow from 'lodash/flow';
import {connect} from 'react-redux';

import {
    removeOrderActions,
    startOrderPaymentActions,
} from 'reducers/depreacted/hotels/bookAndPayPage/orderInfo/actions';

import bookInfoProvider, {
    IBookInfoComponentProps,
} from 'projects/depreacted/hotels/containers/BookInfoProvider/BookInfoProvider';

import PaymentPage from './PaymentPage';

const mapDispatchToProps = {
    removeOrder: removeOrderActions.request,
    startPayment: startOrderPaymentActions.request,
};

interface IPaymentPageContainerProps extends IBookInfoComponentProps {}

export type TPaymentPageProps = IPaymentPageContainerProps &
    typeof mapDispatchToProps;

export default _flow(
    bookInfoProvider(),
    connect(null, mapDispatchToProps),
)(PaymentPage);
