import {PureComponent, ReactNode} from 'react';

import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {reachGoal} from 'utilities/metrika';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import DesktopSearchPage from './components/DesktopSearchPage/DesktopSearchPage';
import MobileSearchPage from './components/MobileSearchPage/MobileSearchPage';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import {TSearchPageContainer} from './SearchPageContainer';

export interface ISearchPage extends TSearchPageContainer {}

const QA_PREFIX = 'hotels-searchPage';

class SearchPage extends PureComponent<ISearchPage> {
    componentDidMount(): void {
        reachGoal(EHotelsGoal.SEARCH_PAGE_VISITED, {
            hotels: {
                didVisitSearchPage: 1,
            },
        });
    }

    renderPageByDevice = (deviceType: IDevice): ReactNode => {
        if (deviceType.isMobile) {
            return (
                <MobileSearchPage
                    deviceType={deviceType}
                    {...this.props}
                    {...prepareQaAttributes(QA_PREFIX)}
                />
            );
        }

        return (
            <DesktopSearchPage
                deviceType={deviceType}
                {...this.props}
                {...prepareQaAttributes(QA_PREFIX)}
            />
        );
    };

    render(): ReactNode {
        return (
            <DeviceTypeContext.Consumer>
                {this.renderPageByDevice}
            </DeviceTypeContext.Consumer>
        );
    }
}

export default SearchPage;
