import {useSelector} from 'react-redux';

import {getResetFilterInfo} from 'selectors/depreacted/hotels/search/searchHotels/getFiltersResetInfo';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import NoHotelsInfo from './components/NoHotelsInfo/NoHotelsInfo';
import ResetList from './components/ResetList/ResetList';

import cx from './FiltersResets.scss';

const FilterResets: React.FC = () => {
    const deviceType = useDeviceType();
    const filtersResetInfo = useSelector(getResetFilterInfo);

    if (!filtersResetInfo) return null;

    return (
        <>
            <NoHotelsInfo
                className={cx('info')}
                deviceType={deviceType}
                reason={filtersResetInfo.resetFilterReason}
            />
            <ResetList
                deviceType={deviceType}
                actions={filtersResetInfo.actions}
                className={cx('list')}
            />
        </>
    );
};

export default FilterResets;
