import React, {useRef, useState} from 'react';

import {useEventListener} from 'utilities/hooks/useEventListener';

import ScopeContext from 'contexts/ScopeContext';

import cx from './SearchFormScroller.scss';

export interface ISearchFormScrollerProps {}

const RISE_TRESHOLD = 35;
const HIDE_THRESHOLD = 70;

const SearchFormScroller: React.FC<ISearchFormScrollerProps> = ({children}) => {
    const prevScrollTop = useRef<number>(0);
    const containerRef = useRef<HTMLDivElement>(null);
    const [isVisible, setVisibility] = useState(true);
    const [isRaised, setRaised] = useState(false);

    const onScroll = (): void => {
        const scrollY = window.scrollY;

        const nextVisible =
            prevScrollTop.current > scrollY || scrollY < HIDE_THRESHOLD;
        const nextRaised = scrollY > RISE_TRESHOLD;

        prevScrollTop.current = scrollY;

        if (isRaised !== nextRaised) setRaised(nextRaised);

        //если открыт попап - не прячем форму + исключаем submit кнопку
        if (
            containerRef.current?.contains(document.activeElement) &&
            document.activeElement?.getAttribute('type') !== 'submit'
        )
            return;

        if (nextVisible !== isVisible) setVisibility(nextVisible);
    };

    useEventListener('scroll', onScroll);

    return (
        <>
            <div
                ref={containerRef}
                className={cx('searchFormScroller', {
                    searchFormScroller__hidden: !isVisible,
                    searchFormScroller__raised: isRaised,
                })}
            >
                <ScopeContext.Provider
                    value={containerRef.current || undefined}
                >
                    {children}
                </ScopeContext.Provider>
            </div>
        </>
    );
};

export default SearchFormScroller;
