import React, {ReactNode, CSSProperties} from 'react';
import {useSelector} from 'react-redux';

import {searchMapSelector} from 'projects/depreacted/hotels/pages/SearchPage/components/DesktopSearchPage/components/SearchPageMap/selectors/searchMapSelector';

import ToggleMapViewButton from '../ToggleMapViewButton/ToggleMapViewButton';

import cx from './SearchPageMap.scss';

export interface ISearchPageMapProps {
    windowHeight: number;
    hasFullScreenMap: boolean;

    renderHotelsMap(className: string, style: CSSProperties): ReactNode;
    onToggleMapView(): void;
}

const SearchPageMap: React.FC<ISearchPageMapProps> = props => {
    const {hasFullScreenMap, renderHotelsMap, onToggleMapView} = props;

    const {canRenderMap} = useSelector(searchMapSelector);

    if (!canRenderMap) {
        return <div className={cx('mapSkeleton')} />;
    }

    return (
        <>
            <ToggleMapViewButton
                className={cx('toggleViewButton')}
                canToggleToFullView={!hasFullScreenMap}
                onClick={onToggleMapView}
            />

            {renderHotelsMap(cx('map'), {
                width: hasFullScreenMap ? '100%' : undefined,
            })}
        </>
    );
};

export default React.memo(SearchPageMap);
