import {FunctionComponent} from 'react';

import {SearchPageLayoutView} from 'types/hotels/search/ISearchLayout';

import * as i18nBlock from 'i18n/hotels-SearchPage';

import MapIcon from 'icons/16/Map';
import ListIcon from 'icons/16/List';
import Hanging from 'components/Hanging/Hanging';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './HangingActiveViewButton.scss';

interface IHangingActiveViewButtonProps {
    activeView: SearchPageLayoutView;
    onClick: () => void;
}

const HangingActiveViewButton: FunctionComponent<IHangingActiveViewButtonProps> =
    ({onClick, activeView}) => {
        const listView = activeView === SearchPageLayoutView.LIST;

        return (
            <Hanging
                className={cx('root', {root_listView: listView})}
                left
                onClick={onClick}
            >
                {listView ? (
                    <TextWithIcon
                        iconLeft={MapIcon}
                        text={i18nBlock.mapTab()}
                    ></TextWithIcon>
                ) : (
                    <TextWithIcon
                        iconLeft={ListIcon}
                        text={i18nBlock.hotelsTab()}
                    ></TextWithIcon>
                )}
            </Hanging>
        );
    };

export default HangingActiveViewButton;
