import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {recentlySearched} from 'i18n/hotels-SearchHotelCard';

import Flex from 'components/Flex/Flex';
import Label, {ELabelThemeType} from 'components/Label/Label';

import cx from './HotelCardLabels.scss';

interface IHotelCardLabels extends IWithClassName, IWithQaAttributes {
    searchedByUser?: boolean;
}

const HotelCardLabels: React.FC<IHotelCardLabels> = props => {
    return (
        <Flex
            className={cx('root', props.className)}
            {...prepareQaAttributes(props)}
            inline
            between="1"
        >
            {props.searchedByUser && (
                <Label className={cx('label')} theme={ELabelThemeType.BRAND}>
                    {recentlySearched()}
                </Label>
            )}
        </Flex>
    );
};

export default HotelCardLabels;
