import React from 'react';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/hotels-SearchHotelCard';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';

const HotelEmptyOffer: React.FC<IWithClassName> = ({className}) => (
    <Box className={className} between="1">
        <Text tag="div" size="m" weight="bold">
            {i18nBlock.emptyOfferTitle()}
        </Text>
        <Text tag="div" size="s">
            {i18nBlock.emptyOfferDescription()}
        </Text>
    </Box>
);

export default HotelEmptyOffer;
