import {Component, ChangeEvent, ReactNode} from 'react';

/* Components */
import Checkbox from 'components/Checkbox/Checkbox';

interface IBaseCheckboxListProps<ItemType, ItemId> {
    className?: string;
    checkboxClassName?: string;
    items: (ItemType & {id: Extract<ItemId, string | number>})[];
    onChange: (payload: {item: ItemType; checked: boolean}) => void;
    renderCheckboxLabel: (item: ItemType) => ReactNode;
    getCheckboxChecked: (item: ItemType) => boolean;
    getCheckboxDisabled: (item: ItemType) => boolean;
}

class BaseCheckboxList<ValueType, ValueId> extends Component<
    IBaseCheckboxListProps<ValueType, ValueId>
> {
    private handleChange = (e: ChangeEvent<HTMLInputElement>): void => {
        const {
            target: {value: itemIndex, checked},
        } = e;
        const {onChange, items} = this.props;
        const item = items[Number(itemIndex)];

        onChange({item, checked});
    };

    render(): ReactNode {
        const {
            items,
            className,
            checkboxClassName,
            getCheckboxDisabled,
            getCheckboxChecked,
            renderCheckboxLabel,
        } = this.props;

        return (
            <div className={className}>
                {items.map((item, index) => (
                    <Checkbox
                        className={checkboxClassName}
                        key={item.id}
                        value={index}
                        disabled={getCheckboxDisabled(item)}
                        checked={getCheckboxChecked(item)}
                        onChange={this.handleChange}
                        label={renderCheckboxLabel(item)}
                    />
                ))}
            </div>
        );
    }
}

export default BaseCheckboxList;
