import {ReactNode} from 'react';

/* Types */
import {IDevice} from 'reducers/common/commonReducerTypes';

/* Utilities */
import {deviceMods} from 'utilities/stylesUtils';

import Flex from 'components/Flex/Flex';
import HorizontalScroller from 'components/HorizontalScroller/HorizontalScroller';

/* Component Types */
export interface IHotelsFiltersBarProps {
    className?: string;
    deviceInfo: IDevice;
    beforeFiltersNode?: ReactNode;
    quickFiltersNode?: ReactNode;
    toggleFiltersVisibilityNode?: ReactNode;
    hotelsHeaderRedesign?: boolean;
}

/* Init Styles*/
import cx from './HotelsFiltersBar.scss';

const HotelsFiltersBar = (props: IHotelsFiltersBarProps) => {
    const {
        deviceInfo,
        className,
        beforeFiltersNode,
        toggleFiltersVisibilityNode,
        quickFiltersNode,
        hotelsHeaderRedesign,
    } = props;

    if (hotelsHeaderRedesign && deviceInfo.isMobile) {
        return (
            <HorizontalScroller scrollableClassName={cx('scrollable')}>
                <Flex
                    className={cx(
                        'filtersBar',
                        'filtersBar_redesign',
                        deviceMods('filtersBar', deviceInfo),
                        className,
                    )}
                    between={deviceInfo.isDesktop ? 5 : 2}
                    flexWrap="nowrap"
                    inline
                >
                    {toggleFiltersVisibilityNode}
                    {quickFiltersNode}
                </Flex>
            </HorizontalScroller>
        );
    }

    return (
        <Flex
            className={cx(
                'filtersBar',
                deviceMods('filtersBar', deviceInfo),
                className,
            )}
            between={deviceInfo.isDesktop ? 5 : 2}
            flexWrap="nowrap"
            inline
        >
            {beforeFiltersNode}
            {quickFiltersNode}
            {toggleFiltersVisibilityNode}
        </Flex>
    );
};

export default HotelsFiltersBar;
