import {IWithClassName} from 'types/withClassName';

/* Init styles */
import cx from './HotelsFiltersBarSkeleton.scss';

/* Component Types */
export interface IHotelsFiltersBarSkeleton extends IWithClassName {}

const HotelsFiltersBarSkeleton = (props: IHotelsFiltersBarSkeleton) => (
    <div className={cx('filtersBar', props.className)}>
        <div className={cx('input')} />
        <div className={cx('quickFilters')}>
            <div className={cx('quickButton', 'quickButton_wide')} />
            <div className={cx('quickButton')} />
            <div className={cx('quickButton')} />
        </div>
        <div className={cx('inputRange')}>
            <div className={cx('inputRangeTrail')} />
            <div className={cx('inputRangeHandle')} />
            <div className={cx('inputRangeHandle', 'inputRangeHandle_right')} />
            <div className={cx('inputRangeTooltip')} />
            <div
                className={cx('inputRangeTooltip', 'inputRangeTooltip_right')}
            />
        </div>
        <div className={cx('toggleButton')} />
    </div>
);

export default HotelsFiltersBarSkeleton;
