import {IRangePriceFilterEstimateValues} from 'types/hotels/search/IFiltersInfo';

/* Steps */
const FIRST_PRICE_STEP = 50;
const SECOND_PRICE_STEP = 100;
const THIRD_PRICE_STEP = 500;
const FOURTH_PRICE_STEP = 1000;

/* Diffs */
const FIRST_PRICE_DIFF = 20000;
const SECOND_PRICE_DIFF = 70000;
const THIRD_PRICE_DIFF = 120000;

const calculateStepByRangeValues = (
    rangeValues: IRangePriceFilterEstimateValues,
): number | undefined => {
    const {minPriceEstimate, maxPriceEstimate} = rangeValues;
    const priceRangeDiff = maxPriceEstimate - minPriceEstimate;

    if (priceRangeDiff) {
        switch (true) {
            case priceRangeDiff <= FIRST_PRICE_DIFF: {
                return FIRST_PRICE_STEP;
            }

            case priceRangeDiff <= SECOND_PRICE_DIFF: {
                return SECOND_PRICE_STEP;
            }

            case priceRangeDiff <= THIRD_PRICE_DIFF: {
                return THIRD_PRICE_STEP;
            }

            default: {
                return FOURTH_PRICE_STEP;
            }
        }
    }

    return undefined;
};

export default calculateStepByRangeValues;
