import {IRangePriceFilterEstimateValues} from 'types/hotels/search/IFiltersInfo';

import calculateStepByRangeValues from 'projects/depreacted/hotels/pages/SearchPage/components/HotelsFilters/components/HotelsPriceFilter/utilities/calculateStepByRangeValues';
import roundToInRange from 'utilities/numbers/roundToInRange';

const transformValues = (
    newValues: readonly number[],
    prevMinValue: number,
    prevMaxValue: number,
    range: IRangePriceFilterEstimateValues,
): readonly number[] => {
    const step = calculateStepByRangeValues(range);

    if (!step) {
        return newValues;
    }

    let [left, right] = newValues;

    if (left !== prevMinValue) {
        left = roundToInRange(
            [range.minPriceEstimate, range.maxPriceEstimate],
            step,
            left,
        );

        return [left, prevMaxValue];
    }

    if (right !== prevMaxValue) {
        right = roundToInRange(
            [range.minPriceEstimate, range.maxPriceEstimate],
            step,
            right,
        );
    }

    return [prevMinValue, right];
};

export default transformValues;
