import React from 'react';

import {
    EQuickFilterEffect,
    TQuickFilter,
} from 'types/hotels/search/IFiltersInfo';

import {IDevice} from 'reducers/common/commonReducerTypes';

import MirCashbackPopupContent from '../MirCashbackPopupContent';

const getHintContent = (
    filter: TQuickFilter,
    deviceType: IDevice,
): React.ReactNode => {
    const isDisabledMIRonTouch =
        deviceType.isTouch &&
        !filter.enabled &&
        filter.effect === EQuickFilterEffect.MIR_CASHBACK;

    if (isDisabledMIRonTouch) {
        return <MirCashbackPopupContent />;
    }

    return filter.hint;
};

export default getHintContent;
