import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';

/* Init styles */
import cx from './MobileHotelsFiltersBarSkeleton.scss';

/* Component Types */
export interface IMobileHotelsFiltersBarSkeletonProps extends IWithClassName {}

const MobileHotelsFiltersBarSkeleton = (
    props: IMobileHotelsFiltersBarSkeletonProps,
) => (
    <div className={cx('filtersBar', props.className)}>
        <div className={cx('toggleViewType', 'hotelBaseElement')} />
        <Flex between={2} inline>
            <div className={cx('quickFilter', 'hotelBaseElement')} />
            <div className={cx('toggleFilters', 'hotelBaseElement')} />
        </Flex>
    </div>
);

export default MobileHotelsFiltersBarSkeleton;
