import React from 'react';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-SearchPageFilters';

import Button from 'components/Button/Button';
import CornerCounter from 'components/CornerCounter/CornerCounter';
import FilterIcon from 'icons/16/Filter';

export interface IToggleFiltersVisibilityButtonProps extends IWithQaAttributes {
    deviceInfo: IDevice;
    canRenderFiltersGroups: boolean;
    hotelsHeaderRedesign?: boolean;
    totalActiveFilters: number;
    onToggleViewFilters: () => void;
}

const ToggleFiltersVisibilityButton: React.FC<IToggleFiltersVisibilityButtonProps> =
    (props: IToggleFiltersVisibilityButtonProps) => {
        const {
            deviceInfo: {isMobile},
            totalActiveFilters,
            onToggleViewFilters,
            hotelsHeaderRedesign,
        } = props;

        return (
            <CornerCounter
                count={totalActiveFilters}
                {...prepareQaAttributes(props)}
            >
                <Button
                    theme={
                        isMobile && !hotelsHeaderRedesign
                            ? 'outlined'
                            : 'secondary'
                    }
                    onClick={onToggleViewFilters}
                    icon={<FilterIcon />}
                    size={isMobile && !hotelsHeaderRedesign ? 'l' : 'm'}
                >
                    {isMobile ? '' : i18nBlock.toggleFiltersVisibility()}
                </Button>
            </CornerCounter>
        );
    };

export default ToggleFiltersVisibilityButton;
