import {getHotelsCurrentFilters} from 'selectors/depreacted/hotels/search/filters/hotelsFiltersSelector';
import deviceTypeSelector from 'selectors/common/deviceTypeSelector';
import {getSearchInfo} from 'selectors/depreacted/hotels/search/searchHotels/getSearchInfo';
import {getTotalActiveFilters} from 'selectors/depreacted/hotels/search/filters/getTotalActiveFilters';
import {getTotalNights} from 'selectors/depreacted/hotels/search/searchHotels/getTotalNights';
import experimentsSelector from 'selectors/common/experimentsSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export const hotelsFiltersSelector = createTypedStructuredSelector({
    deviceInfo: deviceTypeSelector,
    filters: getHotelsCurrentFilters,
    canDisableFilters: state => getSearchInfo(state).isLoading,
    experiments: experimentsSelector,
    nights: getTotalNights,
    totalActiveFilters: getTotalActiveFilters,
});

export type THotelsFilters = ReturnType<typeof hotelsFiltersSelector>;
