import React from 'react';

import {IHotelWithOffers} from 'types/hotels/hotel/IHotelWithOffers';
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';
import {PermalinkType} from 'types/hotels/hotel/IHotel';

import {useExperiments} from 'utilities/hooks/useExperiments';

import ModalWithHistoryBack from 'containers/withSupportHistoryBack/ModalWithHistoryBack/ModalWithHistoryBack';

import HotelCard from 'projects/depreacted/hotels/components/HotelCard/HotelCard';
import MobileMapHotelSnippet from 'projects/depreacted/hotels/pages/SearchPage/components/HotelsSearchMap/components/MobileMapHotelSnippet/MobileMapHotelSnippet';
import MobileSnippetModal from 'projects/depreacted/hotels/pages/SearchPage/components/HotelsSearchMap/components/MobileSnippetModal/MobileSnippetModal';

import cx from './MobileMapHotelCard.scss';

interface IMobileMapHotelCardProps {
    className?: string;
    hotelWithOffers?: IHotelWithOffers;
    nights: number;
    offerRequestParams?: IRequiredOfferParams;
    onOutSideCardClick: () => void;

    onFavoriteClick?({
        permalink,
        isFavorite,
    }: {
        permalink: PermalinkType;
        isFavorite: boolean;
    }): void;
}

const MobileMapHotelCard: React.FC<IMobileMapHotelCardProps> = props => {
    const {
        hotelWithOffers,
        nights,
        onOutSideCardClick,
        offerRequestParams,
        onFavoriteClick,
    } = props;

    const {hotelsNewMapSnippet} = useExperiments();

    if (hotelsNewMapSnippet) {
        return (
            <MobileSnippetModal>
                {hotelWithOffers && (
                    <MobileMapHotelSnippet
                        isFavorite={hotelWithOffers.hotel.isFavorite}
                        nights={nights}
                        offerRequestParams={offerRequestParams}
                        hotelWithOffers={hotelWithOffers}
                        onFavoriteClick={onFavoriteClick}
                    />
                )}
            </MobileSnippetModal>
        );
    }

    if (!hotelWithOffers) {
        return null;
    }

    return (
        <ModalWithHistoryBack
            className={cx('modal')}
            dialogClassName={cx('dialog')}
            isMobile
            isVisible
            verticalAlign="bottom"
            preventBodyScroll
            disableAnimations
            onClose={onOutSideCardClick}
            hasCloseButton={false}
        >
            <HotelCard
                className={cx('hotelCard')}
                offerRequestParams={offerRequestParams}
                nights={nights}
                hotelWithOffers={hotelWithOffers}
                currentPage="map"
            />
        </ModalWithHistoryBack>
    );
};

export default MobileMapHotelCard;
