import {getMap} from 'selectors/depreacted/hotels/search/map/getMap';
import {getSearchInfo} from 'selectors/depreacted/hotels/search/searchHotels/getSearchInfo';
import {textSearchInformationSelector} from 'selectors/depreacted/hotels/search/searchInformation/textSearchInformationSelector';
import {getActiveHotelPermalink} from 'selectors/depreacted/hotels/search/selection/getActiveHotelPermalink';
import {getActiveHotelSource} from 'selectors/depreacted/hotels/search/selection/getActiveHotelSource';
import deviceTypeSelector from 'selectors/common/deviceTypeSelector';
import {getMapBoundsBySearch} from 'selectors/depreacted/hotels/search/map/getMapBoundsBySearch';
import experimentsSelector from 'selectors/common/experimentsSelector';
import {getTotalActiveFilters} from 'selectors/depreacted/hotels/search/filters/getTotalActiveFilters';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export const searchMapSelector = createTypedStructuredSelector({
    hotels: state => getMap(state).hotels,
    hotelWithOffersByPermalink: state =>
        getSearchInfo(state).data?.hotelWithOffersByPermalink,
    nights: state => textSearchInformationSelector(state).nights,
    offerRequestParams: state => getSearchInfo(state).data?.offerSearchParams,
    isLoading: state => getSearchInfo(state).isLoading,
    isSearchFinished: state =>
        !getSearchInfo(state).isLoading &&
        getSearchInfo(state).data?.offerSearchProgress.finished,
    bboxAsStruct: getMapBoundsBySearch,
    withTopHotel: state => Boolean(getSearchInfo(state).data?.topHotelSlug),
    activeHotelPermalink: getActiveHotelPermalink,
    activeHotelSource: getActiveHotelSource,
    selectedMapMarkerPermalink: state =>
        getMap(state).selectedMapMarkerPermalink,
    viewedMapMarkerPermalinks: state => getMap(state).viewedMapMarkerPermalinks,
    isMobile: state => deviceTypeSelector(state).isMobile,
    experiments: experimentsSelector,
    totalActiveFilters: getTotalActiveFilters,
});
