import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import {hotelsSortSelector} from 'projects/depreacted/hotels/pages/SearchPage/components/HotelsSort/selectors/hotelsSortSelector';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BaseHotelsSort, {
    IHotelsSortProps as IBaseHotelsSortProps,
} from 'projects/depreacted/hotels/components/HotelsSort/HotelsSort';

interface IHotelsSortProps extends IWithClassName {
    sortGroupClassName?: string;

    setActiveSort: IBaseHotelsSortProps['setActiveSort'];
    openHotelsGeolocationErrorModal?(): void;

    hotelsHeaderRedesign?: boolean;
}

const HotelsSort: React.FC<IHotelsSortProps> = props => {
    const {
        className,
        sortGroupClassName,
        setActiveSort,
        openHotelsGeolocationErrorModal,
        hotelsHeaderRedesign,
    } = props;

    const {sortInfo, needSyncSortWithServer} = useSelector(hotelsSortSelector);

    const deviceType = useDeviceType();

    return (
        <BaseHotelsSort
            className={className}
            sortGroupClassName={sortGroupClassName}
            sortInfo={sortInfo}
            deviceType={deviceType}
            needSyncSortWithServer={needSyncSortWithServer}
            showIcon={deviceType.isDesktop}
            setActiveSort={setActiveSort}
            openHotelsGeolocationErrorModal={openHotelsGeolocationErrorModal}
            hotelsHeaderRedesign={hotelsHeaderRedesign}
        />
    );
};

export default React.memo(HotelsSort);
