import {useCallback, FunctionComponent} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';

import {setNavigationToken} from 'reducers/depreacted/hotels/searchPage/hotelList/actions';

import {navigationButtonsSelector} from '../NavigationButtons/selectors/navigationButtonsSelector';

import {reachGoal} from 'utilities/metrika';

import InfiniteScrollTrigger from 'components/InfiniteScrollTrigger/InfiniteScrollTrigger';

import HotelSearchCardSkeleton from '../MobileHotelSearchCardSkeleton/MobileHotelSearchCardSkeleton';

import cx from './InfiniteScroll.scss';

const HotelsInfiniteScroll: FunctionComponent = () => {
    const {isLoading, navigationTokens, hasHotels} = useSelector(
        navigationButtonsSelector,
    );
    const dispatch = useDispatch();

    const handleLoad = useCallback(() => {
        if (navigationTokens?.nextPage) {
            dispatch(setNavigationToken(navigationTokens.nextPage));

            reachGoal(EHotelsGoal.SEARCH_PAGE_LIST_PAGE_CHANGE);
        }
    }, [navigationTokens, dispatch]);

    return (
        <InfiniteScrollTrigger
            isLoading={isLoading}
            hasItems={hasHotels}
            onLoadNeeded={handleLoad}
            loadingNode={
                <>
                    <HotelSearchCardSkeleton className={cx('skeleton')} />
                    <HotelSearchCardSkeleton className={cx('skeleton')} />
                </>
            }
        />
    );
};

export default HotelsInfiniteScroll;
