/* Types */
import {FC} from 'react';

import {IWithClassName} from 'types/withClassName';

/* Components */
interface IHotelSearchCardSkeleton extends IWithClassName {}

/* Init styles */
import cx from './MobileHotelSearchCardSkeleton.scss';

const HotelSearchCardSkeleton: FC<IHotelSearchCardSkeleton> = props => (
    <section className={cx('hotelCard', props.className)}>
        <div className={cx('imagesWrapper')}>
            <div className={cx('images')} />
        </div>
        <div className={cx('content')}>
            <div className={cx('hotelName', 'hotelBaseElement')} />
            <div className={cx('hotelRatingAndReviews', 'hotelBaseElement')} />
            <div className={cx('hotelNearestMetro', 'hotelBaseElement')} />
            <div className={cx('badges')}>
                <div className={cx('badge')} />
                <div className={cx('badge')} />
            </div>

            <div className={cx('offerMeal', 'hotelBaseElement')} />
            <div className={cx('offer')}>
                <div className={cx('offerOperator')}>
                    <div className={cx('offerPrice', 'hotelBaseElement')} />
                    <div
                        className={cx('offerOperatorName', 'hotelBaseElement')}
                    />
                </div>
                <div className={cx('offerLink', 'hotelBaseElement')} />
            </div>
        </div>
    </section>
);

export default HotelSearchCardSkeleton;
