import React, {ReactNode} from 'react';

import {SearchPageLayoutView} from 'types/hotels/search/ISearchLayout';
import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';

import {deviceMods} from 'utilities/stylesUtils';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import scrollTo from 'utilities/dom/scrollTo';

import MobileSearchPageLayout from 'projects/depreacted/hotels/pages/SearchPage/components/MobileSearchPageLayout/MobileSearchPageLayout';
import MapListRadioButton from 'projects/depreacted/hotels/pages/SearchPage/components/MapListRadioButton/MapListRadioButton';
import ForceLogin from 'projects/depreacted/hotels/components/ForceLogin/ForceLogin';
import HangingYandexMessenger from 'components/YandexMessenger/components/HangingYandexMessenger/HangingYandexMessenger';

import BaseSearchPage from '../BaseSearchPage/BaseSearchPage';
import InfiniteScroll from '../InfiniteScroll/InfiniteScroll';
import HangingActiveViewButton from '../HangingActiveViewButton/HangingActiveViewButton';

/* Init styles */

import cx from './MobileSearchPage.scss';

/* Constants */
const FIXED_FILTERS_BAR_HEIGHT = 68;
const FIXED_FILTERS_BAR_HEIGHT_REDESIGN = 52;

class MobileSearchPage extends BaseSearchPage {
    componentDidMount(): void {
        const {activeView} = this.state;

        if (activeView === SearchPageLayoutView.MAP) {
            scrollTo({top: 0});
        }
    }

    /* Hotels List */

    renderSortInfoContainer(): React.ReactNode {
        const {
            experiments: {hotelsHeaderRedesign},
        } = this.props;
        const {activeView} = this.state;

        if (activeView !== SearchPageLayoutView.LIST || hotelsHeaderRedesign) {
            return null;
        }

        return <div className={cx('sortSelect')}>{this.renderSortInfo()}</div>;
    }

    renderHotelsListContainer(): ReactNode {
        const {activeView} = this.state;
        const {deviceType, hasBoyOffers, isLoading, hasMirBanner} = this.props;
        const isHotelListView = activeView === SearchPageLayoutView.LIST;

        return (
            <div
                className={cx('hotelsListContainer', {
                    hotelsListContainer_withMap: !isHotelListView,
                })}
            >
                {hasMirBanner
                    ? this.renderMirCashbackBanner(cx('banner'))
                    : isHotelListView && this.renderAdFoxBanner(cx('banner'))}
                <ForceLogin
                    className={cx('forceLogin')}
                    isLoading={isLoading}
                    isSearchPage
                    hasBoyOffers={hasBoyOffers}
                />
                {this.renderHotelsList(cx('hotelsList'))}
                <div
                    className={cx(
                        'searchNavigationButtons',
                        deviceMods('searchNavigationButtons', deviceType),
                    )}
                >
                    {this.renderNavigation()}
                </div>
            </div>
        );
    }

    renderNavigation(): ReactNode {
        const {activeView} = this.state;
        const {
            experiments: {hotelsInfiniteScroll},
        } = this.props;

        if (activeView === SearchPageLayoutView.MAP) {
            return null;
        }

        if (hotelsInfiniteScroll) {
            return <InfiniteScroll />;
        }

        return this.renderSearchNavigationButtons();
    }

    /* Map */

    renderHotelsMapContainer(): ReactNode {
        const {activeView} = this.state;
        const {
            windowWidth,
            windowHeight,
            experiments: {hotelsHeaderRedesign},
        } = this.props;
        const filtersBarHeight = hotelsHeaderRedesign
            ? FIXED_FILTERS_BAR_HEIGHT_REDESIGN
            : FIXED_FILTERS_BAR_HEIGHT;
        const mapHeight = windowHeight - filtersBarHeight;

        if (activeView !== SearchPageLayoutView.MAP) {
            return null;
        }

        return (
            <div className={cx('mapContainer')}>
                {Boolean(mapHeight || this.hotelsMapLoaded) &&
                    this.renderHotelsMap(cx('map'), {
                        height: mapHeight,
                        width: windowWidth,
                    })}
            </div>
        );
    }

    /* Filters */

    renderFiltersContainer(): ReactNode {
        const {activeView} = this.state;

        const isMapView = activeView === SearchPageLayoutView.MAP;

        return (
            <div
                className={cx('filtersContainer', {
                    filtersContainer_withMap: isMapView,
                })}
            >
                {this.renderFilters(this.renderMapListRadioButton())}
            </div>
        );
    }

    renderMapListRadioButton(): ReactNode {
        const {activeView} = this.state;

        return (
            <MapListRadioButton
                className={cx('mapListRadioButton')}
                activeView={activeView}
                onChangeActiveView={this.handleChangeActiveView}
                {...prepareQaAttributes({
                    parent: this.props,
                    current: 'mapListRadioButton',
                })}
            />
        );
    }

    renderHangingButtons() {
        const {
            experiments: {hotelsHeaderRedesign},
        } = this.props;
        const {activeView} = this.state;

        if (!hotelsHeaderRedesign) {
            return null;
        }

        return (
            <HangingActiveViewButton
                activeView={activeView}
                onClick={this.toggleActiveView}
            />
        );
    }

    renderFiltersAndSort(): ReactNode {
        const {
            experiments: {hotelsHeaderRedesign},
        } = this.props;
        const {activeView} = this.state;
        const isListView = activeView === SearchPageLayoutView.LIST;

        if (hotelsHeaderRedesign) {
            return this.renderFiltersAndSortRedesign();
        }

        return (
            <div
                className={cx({
                    headerBorder: isListView,
                })}
            >
                {this.renderFiltersContainer()}
                {this.renderSortInfoContainer()}
            </div>
        );
    }

    renderFiltersAndSortRedesign(): ReactNode {
        return this.renderFilters();
    }

    render(): ReactNode {
        const {
            experiments: {hotelsHeaderRedesign},
        } = this.props;
        const {activeView} = this.state;
        const isListView = activeView === SearchPageLayoutView.LIST;
        const isMapView = activeView === SearchPageLayoutView.MAP;

        return (
            <MobileSearchPageLayout
                className={cx(
                    'mobileSearchPage',
                    isMapView && 'mobileSearchPage_map',
                )}
                searchFormCollapsedClassName={cx(
                    hotelsHeaderRedesign && 'searchForm_redesign',
                )}
                canShowHeader={isListView}
                canShowFooter={isListView}
            >
                {this.renderPreloadChunksControl()}
                {this.renderHotelsSearchController()}
                {this.renderSearchInformationProvider()}
                {this.renderFiltersAndSort()}
                {this.renderHotelsMapContainer()}
                {this.renderHotelsListContainer()}
                <div className={cx('disclaimer')}>
                    {this.renderPromoDisclaimer()}
                </div>
                <HangingYandexMessenger
                    entrypoint="hotelsSearch"
                    metrikaGoal={EHotelsGoal.HOTELS_CHAT_CLICK}
                />
                {this.renderHangingButtons()}
            </MobileSearchPageLayout>
        );
    }
}

export default MobileSearchPage;
