import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {NavigationTokenType} from 'types/hotels/search/INavigationTokens';

import {navigationButtonsSelector} from 'projects/depreacted/hotels/pages/SearchPage/components/NavigationButtons/selectors/navigationButtonsSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import BaseNavigationButtons from 'projects/depreacted/hotels/components/NavigationButtons/NavigationButtons';

interface INavigationButtonsProps extends IWithClassName, IWithQaAttributes {
    onChangeNavigationToken(token: NavigationTokenType): void;
}

const NavigationButtons: React.FC<INavigationButtonsProps> = props => {
    const {className, onChangeNavigationToken} = props;

    const {isLoading, hasHotels, navigationTokens} = useSelector(
        navigationButtonsSelector,
    );

    return (
        <BaseNavigationButtons
            className={className}
            isLoading={isLoading}
            isEmptyList={!hasHotels}
            navigationTokens={navigationTokens}
            onChangeNavigationToken={onChangeNavigationToken}
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(NavigationButtons);
