import {getSearchInfo} from 'selectors/depreacted/hotels/search/searchHotels/getSearchInfo';
import {getHotelList} from 'selectors/depreacted/hotels/search/hotelList/getHotelList';
import {hasHotels} from 'selectors/depreacted/hotels/search/hotelList/hasHotels';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export const navigationButtonsSelector = createTypedStructuredSelector({
    isLoading: state => {
        const {data, isLoading} = getSearchInfo(state);

        return !data?.offerSearchProgress.finished || isLoading;
    },
    hasHotels,
    navigationTokens: state => getHotelList(state).navigationTokens,
});
