import React, {useEffect, useRef, useState} from 'react';

import {hotelsTravellineOfferPage} from 'constants/urls/hotels';

import {ETravellineOfferMessageType} from 'types/hotels/legalOffer/ITravellineOfferMessage';

import Button from 'components/Button/Button';
import Checkbox from 'components/Checkbox/Checkbox';

const token = '123';

// Будет удалена после выполнения задачи
const TravellineOfferPageTest: React.FC = () => {
    const [accepted, setAccepted] = useState<boolean>(false);
    const popupRef = useRef<Window | null>(null);

    const openPopup = (): void => {
        popupRef.current = window.open(
            hotelsTravellineOfferPage,
            '_blank',
            'toolbar=no,scrollbar=no,resizable=no,width=550,height=300',
        );
    };

    const sendToken = (): void => {
        popupRef.current?.postMessage(
            {
                type: ETravellineOfferMessageType.SET_TOKEN,
                payload: {token},
            },
            '*',
        );
    };

    const closePopup = (): void => {
        popupRef.current?.postMessage(
            {
                type: ETravellineOfferMessageType.CLOSE_POPUP,
            },
            '*',
        );
    };

    useEffect(() => {
        const listener = (e: MessageEvent): void => {
            if (
                e.data.type === ETravellineOfferMessageType.OFFER_ACCEPTED &&
                e.data.payload.token === token
            ) {
                setAccepted(true);
            }
        };

        window.addEventListener('message', listener);

        return (): void => window.removeEventListener('message', listener);
    }, []);

    return (
        <div>
            <div>
                <Checkbox label="Офферта принята" checked={accepted} />
            </div>
            <div>
                <Button onClick={openPopup}>Открыть попап</Button>
            </div>

            <div>
                <Button onClick={sendToken}>Передать токен в попап</Button>
            </div>

            <div>
                <Button onClick={closePopup}>Закрыть попап</Button>
            </div>
        </div>
    );
};

export default TravellineOfferPageTest;
