import {EColorZone} from 'types/hotels/search/EColorZone';

const UPPER_LIMIT_OF_GREEN_ZONE = 2500;
const UPPER_LIMIT_OF_YELLOW_ZONE = 4000;

export default function getColorFromRequestsTime(requestsTime: number) {
    if (requestsTime <= UPPER_LIMIT_OF_GREEN_ZONE) {
        return EColorZone.GREEN;
    }

    if (requestsTime <= UPPER_LIMIT_OF_YELLOW_ZONE) {
        return EColorZone.YELLOW;
    }

    return EColorZone.RED;
}
