import {IHotelOrOfferBadge} from 'types/hotels/offer/IHotelOffer';

import {getMirCashbackBadge} from 'projects/depreacted/hotels/utilities/getHotelBadges/getMirCashbackBadge';

import {getHotelAdsBadge} from './getHotelAdsBadge';
import {getHotelDirectBadge} from './getHotelDirectBadge';
import {getWelcomePromocodeBadge} from './getWelcomePromocodeBadge';
import {getHotelTaxiPromocodeBadge} from './getHotelTaxiPromocodeBadge';

const badgeSearchers = [
    getMirCashbackBadge,
    getHotelDirectBadge,
    getWelcomePromocodeBadge,
    getHotelTaxiPromocodeBadge,
    getHotelAdsBadge,
];

interface IOptions {
    hasFirstPromocode?: boolean;
}

/**
 * Получаем бейджи отелей, про которые мы знаем, в правильном порядке
 */
export default function getVisibleHotelBadges(
    badges: IHotelOrOfferBadge[] | null | undefined,
    options: IOptions,
): IHotelOrOfferBadge[] {
    const visibleBadges: IHotelOrOfferBadge[] = [];

    if (!badges) {
        return visibleBadges;
    }

    badgeSearchers.forEach(searcher => {
        const badge = searcher(badges, options);

        if (badge) {
            visibleBadges.push(badge);
        }
    });

    return visibleBadges;
}
