import {select, SelectEffect} from 'redux-saga/effects';

import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';

import {StoreInterface} from 'reducers/storeTypes';

import {getHotelInfo} from 'selectors/depreacted/hotels/hotel/mainTab/getHotelInfo';

export const getSearchParamsByReduxHotelState = function* (): Generator<
    SelectEffect,
    Partial<
        IRequiredOfferParams & {
            hotelSlug: HotelSlugType;
            parentRequestId: string;
        }
    >,
    StoreInterface
> {
    const reduxState: StoreInterface = yield select();
    const {data} = getHotelInfo(reduxState);

    if (data) {
        const {
            parentRequestId,
            searchParams,
            hotel: {hotelSlug},
        } = data;

        if (!searchParams) {
            return {
                hotelSlug,
                parentRequestId,
            };
        }

        const {adults, checkinDate, checkoutDate, childrenAges} = searchParams;

        return {
            adults,
            hotelSlug,
            checkinDate,
            checkoutDate,
            childrenAges,
            parentRequestId,
        };
    }

    return {};
};
