import {
    ISearchPageQueryParams,
    ISearchPageTimeMarkerParams,
} from 'types/hotels/common/IQueryParams';
import {ReactRouterLocationType} from 'types/common/IReactRouterLocation';

import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';
import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';

/* Constants */
const DEFAULT_LAST_SEARCH_TIME_MARKER = -1;

/* Helpers */
export const getLastSearchTimeMarkerQuery = ():
    | ISearchPageTimeMarkerParams
    | undefined => {
    const queryByLocation = getQueryByBrowserHistory();

    if (queryByLocation) {
        const {lastSearchTimeMarker} =
            queryByLocation as ISearchPageQueryParams;

        return {
            lastSearchTimeMarker,
        };
    }
};

export const getLastSearchTimeMarkerByLocation = (
    location: ReactRouterLocationType,
): ISearchPageTimeMarkerParams => {
    const {lastSearchTimeMarker} = getQueryByLocation(location);
    const parsedLastSearchTimeMarker =
        typeof lastSearchTimeMarker === 'string'
            ? parseInt(lastSearchTimeMarker, 10)
            : DEFAULT_LAST_SEARCH_TIME_MARKER;

    return {
        lastSearchTimeMarker: parsedLastSearchTimeMarker
            ? parsedLastSearchTimeMarker
            : DEFAULT_LAST_SEARCH_TIME_MARKER,
    };
};

export const createLastSearchTimeMarker = (): ISearchPageTimeMarkerParams => ({
    lastSearchTimeMarker: Date.now(),
});
