import {ReactRouterMatchType} from 'types/common/IReactRouterLocation';
import {IGeoRegionSlugRouteMatch} from 'types/hotels/geoRegion/IGeoRegionSlugRouteMatch';
import {TGeoRegionSlug} from 'types/hotels/geoRegion/IGeoRegionInfo';

export const getRegionSlugByRouteMatch = (
    match: ReactRouterMatchType<IGeoRegionSlugRouteMatch>,
): TGeoRegionSlug | undefined => {
    const {
        params: {regionSlug},
    } = match;

    if (regionSlug) {
        return regionSlug;
    }

    return undefined;
};
