import {ParsedQuery} from 'query-string';

import {
    SearchPageLayoutView,
    DEFAULT_SEARCH_PAGE_LAYOUT_VIEW,
} from 'types/hotels/search/ISearchLayout';
import {
    ISearchPageLayoutQueryParams,
    ISearchPageQueryParams,
} from 'types/hotels/common/IQueryParams';

import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

/* Helpers */

export const getSearchPageLayoutViewByQuery = (
    queryParams?: ParsedQuery,
): SearchPageLayoutView => {
    if (queryParams) {
        const {serpView} = queryParams as ISearchPageQueryParams;

        return serpView === SearchPageLayoutView.MAP
            ? SearchPageLayoutView.MAP
            : SearchPageLayoutView.LIST;
    }

    return DEFAULT_SEARCH_PAGE_LAYOUT_VIEW;
};

export const getSearchPageLayoutViewQueryParams = (
    searchPageLayoutView?: SearchPageLayoutView,
): ISearchPageLayoutQueryParams => {
    const queryParams = getQueryByBrowserHistory();

    if (queryParams) {
        const {serpView} = queryParams as ISearchPageQueryParams;

        return {
            serpView: searchPageLayoutView ? searchPageLayoutView : serpView,
        };
    }

    return {};
};
