import {generatePath} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {IUrlQuery} from 'utilities/url/types';

import {internalUrl} from 'utilities/url';

export const getHotelBySlugUrl = (
    params: {
        regionSlug: string;
        hotelSlug: string;
    },
    query?: IUrlQuery,
    hash?: string,
): string => {
    return internalUrl(
        generatePath(URLs.hotelsHotelWithSlug, params),
        query,
        null,
        undefined,
        hash,
    );
};
