import {ParsedQuery} from 'query-string';

import {URLs} from 'constants/urls';

import {IHotelPageQueryParams} from 'types/hotels/common/IQueryParams';
import {ISearchParamsForHotelUrl} from './types';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';

import {getChildrenAgesQueryParam} from 'projects/depreacted/hotels/utilities/getRequiredOfferSearchQuery/getRequiredOfferSearchQuery';
import {getAttributionQueryParams} from 'projects/depreacted/hotels/utilities/getAttributionParams/getAttributionParams';
import {internalUrl} from 'utilities/url';
import {getStoredSrcQueryParams} from 'utilities/srcParams/srcParams';

export const getHotelUrlByHotelSlug = (hotelSlug: HotelSlugType): string =>
    `${URLs.hotels}/${hotelSlug}`;

export const getHotelUrlByPermalink = (permalink: number): string =>
    `${URLs.hotelsHotelWithPermalink}/${permalink}`;

const baseHotelUrl =
    () =>
    (
        searchParams: ISearchParamsForHotelUrl,
        queryByLocation?: ParsedQuery,
        queryParams?: IHotelPageQueryParams,
    ): string => {
        const {
            adults,
            seed,
            hotelSlug,
            checkinDate,
            checkoutDate,
            childrenAges,
        } = searchParams;

        const hotelPageQueryParams: IHotelPageQueryParams = {
            seed,
            adults,
            checkinDate,
            checkoutDate,
            childrenAges: getChildrenAgesQueryParam(childrenAges),
            ...getStoredSrcQueryParams(),
            ...getAttributionQueryParams(queryByLocation),
            ...queryParams,
        };

        return internalUrl(
            getHotelUrlByHotelSlug(hotelSlug),
            hotelPageQueryParams,
            {
                filterNull: true,
            },
        );
    };

export const getHotelUrl = baseHotelUrl();
